<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Patient extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'patient_id',
        'title',
        'first_name',
        'last_name',
        'date_of_birth',
        'gender',
        'identity_number',
        'phone_area_code',
        'phone_number',
        'email',
        'payment_mode',
        'medical_aid_number',
        'main_member',
    ];

    protected $casts = [
        'date_of_birth' => 'date',
    ];

    public function appointments()
    {
        return $this->hasMany(Appointment::class);
    }

    public function medicalHistories()
    {
        return $this->hasMany(MedicalHistory::class);
    }

    public function prescriptions()
    {
        return $this->hasMany(Prescription::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function getFullNameAttribute()
    {
        return "{$this->title} {$this->first_name} {$this->last_name}";
    }

    public function getFullPhoneAttribute()
    {
        return $this->phone_area_code ? "{$this->phone_area_code} {$this->phone_number}" : $this->phone_number;
    }
}

